package SCGAP::Gene;

###############################################################################
# Class       : SCGAP::Gene
# Author      : Eric Deutsch <edeutsch@systemsbiology.org>
# $Id$
#
# Description : This class is used to represent a gene and its gene
#               coordinates has defined by the SCGAP system in development
#
###############################################################################

use strict;


###############################################################################
# Constructor
###############################################################################
sub new {
  my $self = shift;
  my %parameters = @_;

  my $class = ref($self) || $self;

  #### Create the object with any attributes if supplied
  bless {
	 _taxon_id => $parameters{taxon_id},
	 _chromosome => $parameters{chromosome},
	 _start_coordinate => $parameters{start_coordinate},
	 _end_coordinate => $parameters{end_coordinate},
	 _strand => $parameters{strand},
	} => $class;
}



###############################################################################
# set_taxon_id: Set attribute taxon_id
###############################################################################
sub set_taxon_id {
  my $self = shift;
  $self->{_taxon_id} = shift;
  return $self->{_taxon_id};
}


###############################################################################
# get_taxon_id: Get attribute taxon_id
###############################################################################
sub get_taxon_id {
  my $self = shift;
  return $self->{_taxon_id};
}



###############################################################################
# set_chromosome: Set attribute chromosome
###############################################################################
sub set_chromosome {
  my $self = shift;
  $self->{_chromosome} = shift;
  return $self->{_chromosome};
}


###############################################################################
# get_chromosome: Get attribute chromosome
###############################################################################
sub get_chromosome {
  my $self = shift;
  return $self->{_chromosome};
}



###############################################################################
# set_start_coordinate: Set attribute start_coordinate
###############################################################################
sub set_start_coordinate {
  my $self = shift;
  $self->{_start_coordinate} = shift;
  return $self->{_start_coordinate};
}


###############################################################################
# get_start_coordinate: Get attribute start_coordinate
###############################################################################
sub get_start_coordinate {
  my $self = shift;
  return $self->{_start_coordinate};
}



###############################################################################
# set_end_coordinate: Set attribute end_coordinate
###############################################################################
sub set_end_coordinate {
  my $self = shift;
  $self->{_end_coordinate} = shift;
  return $self->{_end_coordinate};
}


###############################################################################
# get_end_coordinate: Get attribute end_coordinate
###############################################################################
sub get_end_coordinate {
  my $self = shift;
  return $self->{_end_coordinate};
}



###############################################################################
# set_strand: Set attribute strand
###############################################################################
sub set_strand {
  my $self = shift;
  $self->{_strand} = shift;
  return $self->{_strand};
}


###############################################################################
# get_strand: Get attribute strand
###############################################################################
sub get_strand {
  my $self = shift;
  return $self->{_strand};
}


###############################################################################
# is_valid: returns 1 if the specification appears valid or 0 if not
###############################################################################
sub is_valid {
  my $self = shift;
  # WRITE ME!
  return 1;
}


###############################################################################
# get_identifier: returns a string auto-generated identifier
###############################################################################
sub get_identifier {
  my $self = shift;
  my $identifier = "tax".$self->get_taxon_id().":chr".$self->get_chromosome().
    ":".$self->get_start_coordinate()."-".$self->get_end_coordinate().
    $self->get_strand();
  return $identifier;
}


###############################################################################
1;
