#!/usr/local/bin/perl -w

#### Set up local modules
use SCGAP::Gene;
use SCGAP::GeneExpression;
use Data::Dumper;

#### Configure SOAP connection to ISB
use SOAP::Lite(
  uri => 'ISB SOAP Server',
  proxy => 'http://db.systemsbiology.net/cgi-bin/soap.cgi',
  on_fault => sub { my($soap, $res) = @_;
    die ref $res ? $res->faultdetail : $soap->transport->status, "\n";
  }
);


#### Define a gene
my $gene = new SCGAP::Gene (
  taxon_id => 9606,
  chromosome => 10,
  start_coordinate => 312434,
  end_coordinate => 321895,
  strand => '+',
);
my $gene_identifier = $gene->get_identifier();


#### Create a gene expression information object and set the gene identifier
my $geneExp = new SCGAP::GeneExpression;
$geneExp->set_gene($gene);


#### Throw the object to Seattle to invoke get_expression_information()
print "Requesting prostate expression information for gene ".
  "'$gene_identifier'\n";
$geneExp->SOAP::get_gene_expression();
#$geneExp->get_gene_expression();    # a local call which is uninteresting


#### Print status and result information
print "Status: ",$geneExp->get_status(),"\n";
my $result = $geneExp->get_result();
print "Return result for gene '".$geneExp->get_gene()->get_identifier().
  "': ",$result,"\n";
print Data::Dumper->Dump([ $result ]),"\n";
