package SCGAP::GeneExpression;


###############################################################################
# Class       : SCGAP::GeneExpression
# Author      : Eric Deutsch <edeutsch@systemsbiology.org>
# $Id$
#
# Description : This class is used to represent a gene expression
#               result as part of the SCGAP system in development
#
###############################################################################

use strict;
use SCGAP::Gene;


###############################################################################
# Constructor
###############################################################################
sub new {
  my $self = shift;
  my %parameters = @_;

  my $class = ref($self) || $self;

  #### Create the object with any attributes if supplied
  bless {
	 _gene => $parameters{gene},
	 _status => $parameters{status} || 'idle',
	 _result => $parameters{result} || '',
	} => $class;
}


###############################################################################
# set_gene: Set attribute gene
###############################################################################
sub set_gene {
  my $self = shift;
  $self->{_gene} = shift;
  return $self->{_gene};
}


###############################################################################
# get_gene: Get attribute gene
###############################################################################
sub get_gene {
  my $self = shift;
  return $self->{_gene};
}



###############################################################################
# set_status: Set attribute status
###############################################################################
sub set_status {
  my $self = shift;
  $self->{_status} = shift;
  return $self->{_status};
}


###############################################################################
# get_status: Get attribute status
###############################################################################
sub get_status {
  my $self = shift;
  return $self->{_status};
}



###############################################################################
# set_result: Set attribute result
###############################################################################
sub set_result {
  my $self = shift;
  $self->{_result} = shift;
  return $self->{_result};
}


###############################################################################
# get_result: Get attribute result
###############################################################################
sub get_result {
  my $self = shift;
  return $self->{_result};
}


###############################################################################
# get_gene_expression: Get expression information about this gene and return it
###############################################################################
sub get_gene_expression {
  my $self = shift;
  my $gene = shift || $self->{_gene};

  #### Verify that we have a gene coordinate
  unless (defined($gene) && ref($gene) && $gene->is_valid()) {
    $self->{_status} = "ERROR: gene not specified or invalid";
    return $self->{_status};
  }


  #### Create a mock response just as a has for now
  $self->{_result} = "There may be expression for gene '".
    $gene->get_identifier()."' but you'll have to ask someone else.";

  $self->{_status} = "Success";
  return $self->{_status};

}


###############################################################################
1;
